#pragma once

/***
  This file is part of systemd.

  Copyright 2010 Lennart Poettering

  systemd is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 2.1 of the License, or
  (at your option) any later version.

  systemd is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with systemd; If not, see <http://www.gnu.org/licenses/>.
***/

#include <stdbool.h>

int log_facility_unshifted_to_string_alloc(int i, char **s);
int log_facility_unshifted_from_string(const char *s);
#if 0 /// UNNEEDED by elogind
bool log_facility_unshifted_is_valid(int faciliy);
#endif // 0

int log_level_to_string_alloc(int i, char **s);
int log_level_from_string(const char *s);
#if 0 /// UNNEEDED by elogind
bool log_level_is_valid(int level);

int syslog_parse_priority(const char **p, int *priority, bool with_facility);
#endif // 0
